  /*
   *  Object          : sst_host_op_code.h
   *  State           :  %state%
   *  Creation date   :  Wed Nov 17 17:26:15 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief this file containes the declerations of the SST HOST-SEP and vice versa op codes..
   *         
   *
   *  \version host_op_code.h#1:csrc:3
   *  \author einatr
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ****************/
#include "host_op_code.h"

/************************ Defines ******************************/


/************************ Enums ******************************/

typedef enum
{

    SST_SEP_OP_CODE_INIT		                        = DX_SEP_HOST_SEP_PROTOCOL_HOST_SST_FIRST_OP_CODE,/*0x500*/
    SST_SEP_OP_CODE_TERMINATE	                        ,
    
    SST_SEP_OP_CODE_AUTH_PASSWORD_CREATE			    ,/*0x502*/
    SST_SEP_OP_CODE_AUTH_APP_ID_CREATE					,
    SST_SEP_OP_CODE_AUTH_PUB_KEY_RSA_CREATE			    ,
    SST_SEP_OP_CODE_AUTH_PUB_KEY_ECC_CREATE			    ,
    SST_SEP_OP_CODE_AUTH_AES_SHARED_SECRET_CREATE	    ,
    SST_SEP_OP_CODE_AUTH_DELETE						    ,
    SST_SEP_OP_CODE_AUTH_SESSION_CREATE				    ,
    SST_SEP_OP_CODE_AUTH_SESSION_DELETE				    ,
    SST_SEP_OP_CODE_AUTH_CHALLENGE_GET				    ,
    SST_SEP_OP_CODE_AUTH_OPEN						    ,
    SST_SEP_OP_CODE_AUTH_CLOSE						    ,
    SST_SEP_OP_CODE_AUTH_PASSWORD_RESET_AND_CHANGE	    ,
    SST_SEP_OP_CODE_AUTH_BIND						    ,
    SST_SEP_OP_CODE_AUTH_UNBIND						    ,

    SST_SEP_OP_CODE_DATA_INSERT						    ,/*0x510*/
    SST_SEP_OP_CODE_DATA_READ_ONLY_SET				    ,
    SST_SEP_OP_CODE_DATA_READ						    ,
    SST_SEP_OP_CODE_DATA_MODIFY						    ,
    SST_SEP_OP_CODE_DATA_SIZE_GET					    ,
    SST_SEP_OP_CODE_DATA_DELETE						    ,
    
    SST_SEP_OP_CODE_TRANSACTION_START				    ,/*0x516*/
    SST_SEP_OP_CODE_TRANSACTION_END					    ,
    SST_SEP_OP_CODE_TRANSACTION_ROLLBACK			    ,

    SST_SEP_OP_CODE_INDEX_LOOK_UP_DELETE				,/*0x519*/
    SST_SEP_OP_CODE_INDEX_LOOK_UP_BIND					,
    SST_SEP_OP_CODE_INDEX_LOOK_UP_UNBIND				,
    SST_SEP_OP_CODE_INDEX_LOOK_UP_BEGIN					,
    SST_SEP_OP_CODE_INDEX_LOOK_UP_HANDLES_GET			,
    SST_SEP_OP_CODE_INDEX_LOOK_UP_END					,
    
    SST_SEP_OP_CODE_TYPE_ITERATOR_BEGIN					,/*0x51f*/
    SST_SEP_OP_CODE_TYPE_ITERATOR_TERMINATE				,
    SST_SEP_OP_CODE_TYPE_ITERATOR_HANDLE_INC_AND_GET	,
    SST_SEP_OP_CODE_TYPE_ITERATOR_HANDLE_DEC_AND_GET	,
    SST_SEP_OP_CODE_TYPE_ITERATOR_CURRENT_GET			,
    SST_SEP_OP_CODE_TYPE_ITERATOR_HANDLES_GET			,

    SST_SEP_OP_CODE_VERSION_GET							,/*0x525*/

    SST_SEP_OP_CODE_KM_AES_INSERT						,/*0x526*/
    SST_SEP_OP_CODE_KM_AES_GEN							,
    SST_SEP_OP_CODE_KM_AES_READ							,
    SST_SEP_OP_CODE_KM_DES_INSERT						,
    SST_SEP_OP_CODE_KM_DES_GEN							,
    SST_SEP_OP_CODE_KM_DES_READ							,
    SST_SEP_OP_CODE_KM_HMAC_INSERT						,
    SST_SEP_OP_CODE_KM_HMAC_GEN							,
    SST_SEP_OP_CODE_KM_HMAC_READ						,
    SST_SEP_OP_CODE_KM_RSA_INSERT						,
    SST_SEP_OP_CODE_KM_RSA_GEN							,
    SST_SEP_OP_CODE_KM_RSA_READ							,
    SST_SEP_OP_CODE_KM_CRTRSA_INSERT					,
    SST_SEP_OP_CODE_KM_CRTRSA_GEN						,
    SST_SEP_OP_CODE_KM_CRTRSA_READ						,/*0x534*/
 	
    SST_SEP_OP_CODE_DATA_TYPE_GET						,/*0x535*/
    SST_SEP_OP_CODE_DATA_HANDLE_BUILD					,/*0x536*/
    SST_SEP_OP_CODE_WORKSPACE_SIZE_GET   				,
    SST_SEP_OP_CODE_NVS_MAX_SIZE_SET 					,/*0x538*/  
    SST_SEP_OP_CODE_NVS_SIZE_GET 						,/*0x539*/  
    
    SST_SEP_OP_CODE_DATA_REPLACE						,/*0x53A*/
    SST_SEP_OP_CODE_MM_GET								,/*0x53B*/
    SST_SEP_OP_CODE_MM_SET								,/*0x53C*/
    SST_SEP_OP_CODE_MM_AUTH_SET							,/*0x53D*/
    SST_SEP_OP_CODE_MM_PRIV_AUTH_CREATE 				,/*0x53E*/
    SST_SEP_OP_CODE_MM_PRIV_AUTH_OPEN 				     /*0x53F*/
    
}DX_SEP_HOST_SEP_SST_OP_CODE_t;
/************************ Typedefs ******************************/


/************************ Global Data ******************************/


/************* Private function prototypes ****************/
